#$Id: config.pl.official 6 2006-02-15 12:12:33Z gregor $

$IPROUTE="/sbin/ip";
$VCONFIG="/sbin/vconfig";
$SYSCTL="/sbin/sysctl";
$IPTABLES="/usr/local/sbin/iptables";
$IP6TABLES="/usr/local/sbin/ip6tables";

$DO_NETWORK_SETUP="YES";


$FW_BASE="/root/netfico";
$RULES_D="$FW_BASE/rules.d";

# a helper var to sabe typing
my $SLASH_48="2001:0db8:2001";

$VLAN_CARRIER_IFACE="eth0";

# The IP hash contains definitions of IP-Addresses or IP-Ranges that can
# be used to narrow down rules. The entries can be used as TO_SPECIFIATION,
# FROM_SPECIFICATION or CONSTRAINING_ADDR_RANGE parameteres in the rules.d/
# files. 
#
# To reference one of these entries use the ip:HASHKEY form. Where ip: is a 
# literal and HASKEY is the key into the IP hash. 
#
# The entries of the IP-Hash are itself hashes with two possible keys, 
# namely net4 and net6. 
# "net4"   specified the IPv4 address range of this entry in address/prefixlen
#      format. Thus you can use a.b.c.d/32 to specify a single host. 
# "net6"   specified the IPv6 address range of this entry in address/prefixlen
#      format. Thus you can use IPv6-Addr/128 to specify a single host. 
$IP{'test'} = {
	"net4" => "1.2.3.4/16",
	"net6" => "$SLASH_48:FFFF::/64"
};

$IP{'lrzvpn'} = {
	"net4" => "129.187.254.0/24"
};

$IP{'adsm'} = {
	"net4" => "10.151.8.16/32"
};


$IP{'myserver'} = {
	"net4" => "192.168.142.10/32",
	"net6" => "$SLASH_48:142::1:1/128"
};

#
# The CONFIG Hash contains the configuration of the network interfaces and
# an the connected subnets. 
#
# The special keyword "any" MUST NOT be used as a key for the CONFIG hash!
#
# An entry of the CONFIG hash is itself another hash, with following possible
# keys:
#
# "iface"  the interface of this subnet for transporting IPv4 and IPv6
# "iface4"  the interface of this subner for transporting IPv4 only
# "iface6"  the interface of this subner for transporting IPv6 only
#     The use of "iface" and iface4 or iface6 is NOT ALLOWD. This seperation
#     is here to account for the same logical subnet having different interfaces
#     for IPv4 and IPv6 traffic. This will most likely be the case for external
#     interfaces (like having a ppp connection for IPv4 but a 6-in-4 tunnel for 
#     IPv6 traffic. 
# "ip4"   the IPv4 addresse of this interface. Can be specified by as either an
#     ip-address or in ip/prefixlen syntax. If the prefixlen is omitted, the
#     prefixlen of the net4 specification will be used.
#     Do not use /32 as prefixlen, use the prefixlen of the subnet connected there
# "net4"   the specification of the connected subnet in address/prefixlen syntax
# "ip6"   the IPv6 addresse of this interface. Can be specified by as either an
#     ip-address or in ip/prefixlen syntax. If the prefixlen is omitted, the
#     prefixlen of the net6 specification will be used.
# "net6"   the specification of the connected subnet in address/prefixlen syntax
#     of course you can ommit the v4 or the v6 specs if a subnet is only capable of 
#     carring just one of these protocols
# "type"   is either empty or "xfer". If it is "xfer", this means, that the subnet
#     is not directly connected to the interface. An intermediate network is between
#     (a transfer network or a ppp link). In this case the address in the ip4 resp. ip6
#     field will be in a different network than the destination spec of net4 resp. net6. 
#     In this case it is REQUIRED that you use the address/prefixlen syntax for ip4, ip6.
# "nexthop4"  if type is "xfer" this entry specifies the IPv4 address of the gateway for
#     the subnet net4
# "nexthop6"  if type is "xfer" this entry specifies the IPv6 address of the gateway for
#     the subnet net6
# 
$CONFIG{'extern'} = {
	"type" => "xfer",
	"iface" => "eth2",
	"net4" => "0.0.0.0/0",
	"ip4" => "132.15.159.200/27",
	"nexthop4" => "132.15.159.222"
};

$CONFIG{'net1'} = {
	"iface"	=> "vlan142",
	"net4" => "192.168.142.0/24",
	"ip4" => "192.168.142.1",
	"net6" => "$SLASH_48:142::/64",
	"ip6" => "$SLASH_48:142::1"
	};

$CONFIG{'net2'} = {
	"iface"	=> "vlan143",
	"net4" => "192.168.143.0/24",
	"ip4" => "192.168.143.1",
	"net6" => "$SLASH_48:143::/64",
	"ip6" => "$SLASH_48:143::1"
	};


