#!/usr/bin/perl
#
#
#
# $Id: fw_setup.pl 5 2006-02-15 12:09:03Z gregor $
#
#Copyright (c) 2006 Gregor Maier <gregor@majordomus.org>
#All rights reserved.
#
#
#Redistribution and use in source and binary forms, with or without
#modification, are permitted provided that the following conditions
#are met:
#
#1. Redistributions of source code must retain the above copyright
#   notice, this list of conditions and the following disclaimer.
#2. Redistributions in binary form must reproduce the above copyright
#   notice, this list of conditions and the following disclaimer in the
#   documentation and/or other materials provided with the distribution.
#3. Neither the names of the copyright owners nor the names of its
#   contributors may be used to endorse or promote products derived from
#   this software without specific prior written permission.
#
#THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
#WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
#MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
#IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
#DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
#DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
#GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
#INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
#IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
#OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
#ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#
#


return 1;


#
# Flush Buildin Chains.
# Delete custom chains
# Set Policy
#
sub fw_init {
	my @commands = (
		"$IPTABLES  -F", 
		"$IP6TABLES -F", 
		#"$IPTABLES  -t nat -F", 
		#"$IP6TABLES -t nat -F",   nat table does not exist for ipv6
		"$IPTABLES  -t mangle -F", 
		"$IP6TABLES -t mangle -F", 

		"$IPTABLES  -X", 
		"$IP6TABLES -X", 

		"$IPTABLES  -P INPUT DROP", 
		"$IP6TABLES -P INPUT DROP", 
		"$IPTABLES  -P FORWARD DROP", 
		"$IP6TABLES -P FORWARD DROP", 
		"$IPTABLES  -P OUTPUT DROP", 
		"$IP6TABLES -P OUTPUT DROP",
		"$IPTABLES -A INPUT -i lo -j ACCEPT",
		"$IP6TABLES -A INPUT -i lo -j ACCEPT",
		"$IPTABLES -A OUTPUT -o lo -j ACCEPT",
		"$IP6TABLES -A OUTPUT -o lo -j ACCEPT",
	);

	foreach (@commands) {
		gmsystem($_);
	}
}


#
# Create the Chains 
# Add rules to the FORWARD and XBAR chains 
#
sub fw_setup_chains {
	my $cursubnet;	
	my $curconfig;
	my ($cmdparam, $chain);
	my ($iface4, $iface6);

	#
	# The FROM_* chains
	#
	foreach $cursubnet (keys %CONFIG) {
		$curconfig = $CONFIG{$cursubnet};
		($iface4, $iface6) = extract_iface($curconfig, $cursubnet);
		# crate chains
		$chain = "FROM_" . uc($cursubnet);
		gmsystem("$IPTABLES -N $chain");
		gmsystem("$IP6TABLES -N $chain");
		
		# Add rule to jump to chain
		if ($curconfig->{'net4'} ne "") {
			$cmdparam = "-A FORWARD -i " . $iface4 . " -s " . $curconfig->{'net4'} . " -j $chain";
			$cmdparam =~ s/default/0.0.0.0\/0/;
			gmsystem("$IPTABLES $cmdparam");
		}
		if ($curconfig->{'net6'} ne "") {
			$cmdparam = "-A FORWARD -i " . $iface6 . " -s " . $curconfig->{'net6'} . " -j $chain";
			$cmdparam =~ s/default/::\/0/;
			gmsystem("$IP6TABLES $cmdparam");
		}
	}
	
	#
	# Creaete the croccbasr chain
	#
	gmsystem("$IPTABLES -N XBAR");
	gmsystem("$IP6TABLES -N XBAR");

	#
	# The TO_* chains
	#
	# We interate a second time through the subnets. not
	# necesarry but the chains are genereated in the order
	# that packets will traverse them (FROM_, XBAR, TO_)
	foreach $cursubnet (keys %CONFIG) {
		$curconfig = $CONFIG{$cursubnet};
		($iface4, $iface6) = extract_iface($curconfig, $cursubnet);
		$chain = "TO_" . uc($cursubnet);
		gmsystem("$IPTABLES -N $chain");
		gmsystem("$IP6TABLES -N $chain");

		if ($curconfig->{'net4'} ne "") {
			$cmdparam = "-A XBAR -o " . $iface4 . " -d " . $curconfig->{'net4'} . " -j $chain";
			$cmdparam =~ s/default/0.0.0.0\/0/;
			gmsystem("$IPTABLES $cmdparam");
		}
		if ($curconfig->{'net6'} ne "") {
			$cmdparam = "-A XBAR -o " . $iface6 . " -d " . $curconfig->{'net6'} . " -j $chain";
			$cmdparam =~ s/default/::\/0/;
			gmsystem("$IP6TABLES $cmdparam");
		}
	}
	
}



sub fw_config {
	my ($curconfig);
	my @line;
	my $func;
	my $chain;

	foreach $SUBNET (keys %CONFIG) {
		$curconfig = $CONFIG{$SUBNET};

		$LINENUM = 0;
		if (! -r "$RULES_D/$SUBNET" ) {
			print STDERR "WARNING: No rules for subnet $SUBNET defined. Skipping\n";
			next;
		}
		open IN,"<$RULES_D/$SUBNET"  
			or die "FATAL: open failed although we checked that the file $SUBNET is readable!\n";
		print "DEBUG: file opened.\n";
		while (<IN>) {
			chomp;
			$LINENUM++;
			# Skip comments and empty lines
			next if /^\s*#/;
			next if /^\s*$/;
			#print ">>>$_<<<\n";
			@line = split '\s+', $_;
			$func = shift @line;
			if (@line != 0) {
				my $i;
				for ($i=0; $i<@line; $i++) {
					$line[$i] = '"' . $line[$i] . '"';
				}
				$func .= "(" . join(",", @line) . ");";
			}
			print "DEBUG: $func\n";	
			eval($func);
			print STDERR "ERROR: $SUBNET:$LINENUM: $@\n" if $@;
		}
		close IN;
	}
}

#
# Append a rule to LOG and a DROP at the end of each chain
sub fw_append_drop {
	my $chain, $cmdparam;

	#
	# Add a LOG target to the end of the FORWARD chain
	#
	$cmdparam = "-A FORWARD -j LOG --log-prefix \"DROP FORWARD\"";
	gmsystem("$IPTABLES $cmdparam");
	gmsystem("$IP6TABLES $cmdparam");
	$cmdparam = "-A FORWARD -j DROP";
	gmsystem("$IPTABLES $cmdparam");
	gmsystem("$IP6TABLES $cmdparam");

	#
	# Add a DROP TARGET and LOG target to the end of the XBAR
	#
	$cmdparam = "-A XBAR -j LOG --log-prefix \"DROP XBAR \"";
	gmsystem("$IPTABLES $cmdparam");
	gmsystem("$IP6TABLES $cmdparam");
	$cmdparam = "-A XBAR -j DROP";
	gmsystem("$IPTABLES $cmdparam");
	gmsystem("$IP6TABLES $cmdparam");

	foreach $SUBNET (keys %CONFIG) {
		$chain = "FROM_" . uc($SUBNET);
		$cmdparam = "-A $chain -j LOG --log-prefix \"DROP $chain \"";
		gmsystem("$IPTABLES $cmdparam");
		gmsystem("$IP6TABLES $cmdparam");
		$cmdparam = "-A $chain -j DROP";
		gmsystem("$IPTABLES $cmdparam");
		gmsystem("$IP6TABLES $cmdparam");

		$chain = "TO_" . uc($SUBNET);
		$cmdparam = "-A $chain -j LOG --log-prefix \"DROP $chain \"";
		gmsystem("$IPTABLES $cmdparam");
		gmsystem("$IP6TABLES $cmdparam");
		$cmdparam = "-A $chain -j DROP";
		gmsystem("$IPTABLES $cmdparam");
		gmsystem("$IP6TABLES $cmdparam");
	}
}

