#!/usr/bin/perl
#
# $Id: main.pl 2 2006-01-26 13:01:15Z gregor $
#
#Copyright (c) 2006 Gregor Maier <gregor@majordomus.org>
#All rights reserved.
#
#
#Redistribution and use in source and binary forms, with or without
#modification, are permitted provided that the following conditions
#are met:
#
#1. Redistributions of source code must retain the above copyright
#   notice, this list of conditions and the following disclaimer.
#2. Redistributions in binary form must reproduce the above copyright
#   notice, this list of conditions and the following disclaimer in the
#   documentation and/or other materials provided with the distribution.
#3. Neither the names of the copyright owners nor the names of its
#   contributors may be used to endorse or promote products derived from
#   this software without specific prior written permission.
#
#THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
#WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
#MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
#IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
#DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
#DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
#GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
#INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
#IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
#OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
#ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#
#
#
#
#
#
#
use strict;
# Variables used by the fw_functions
use vars qw($SUBNET $LINENUM);
# Binaries we need to call 
use vars qw($IPROUTE $VCONFIG $SYSCTL $IPTABLES $IP6TABLES);
# Other global config parameters
use vars qw($DO_NETWORK_SETUP $FW_BASE $RULES_D %IP %CONFIG $VLAN_CARRIER_IFACE);

require ("config.pl");
require ("network_setup.pl");
require ("fw_setup.pl");
require ("fw_functions.pl");
#eval `cat fw_functions.pl`;


&main;



sub main {
	# Set sysctl networking options 
	if (-r "$FW_BASE/sysctl.prestart.conf") {
		gmsystem("$SYSCTL -p $FW_BASE/sysctl.prestart.conf");
	}
	
	&fw_init;
	&fw_setup_chains;
	&fw_config;
	&xxx_allow_me;
	&fw_append_drop;

	if ($DO_NETWORK_SETUP =~ /yes/i) {
		&network_setup;
	}
	# Set sysctl networking options 
	if (-r "$FW_BASE/sysctl.postconfig.conf") {
		gmsystem("$SYSCTL -p $FW_BASE/sysctl.poststart.conf");
	}
} # end main


#
# Run a command with system and do some error handling if the
# command fails
#
sub gmsystem {
	my $cmd = shift;
	my $prefix = shift;

	if ($prefix eq "") {
		$prefix = "ERROR";
	}
	print "$cmd\n";
	if (system($cmd) != 0) {
		print STDERR "$prefix: $cmd failed\n";
	}
}

