#!/usr/bin/env bash

# Generate some domain names from effective_tld_names.dat
./make-testfile.py < TEST.dat > TEST.domain


# This disabled block here could be used to check this python
# implementation against a PHP implementation that's been 
# around for a while: 
if false; then
	# We compare against the PHP implementation. But since I don't know
	# how they handle punycode domains, I convert the rule file to
	# punycode:
	./strip-and-reencode-dat.py < TEST.dat > reg-domain-lib/effective_tld_names.dat 
	cd reg-domain-lib
	php generateEffectiveTLDs.php php  > PHP/effectiveTLDs.inc.php
	cd ..
	# This is incredibly slow :-( 
	xargs -n1 php reg-domain-lib/PHP/test-regDomain.php < TEST.domain > TEST.out.theirs
	echo "Now diff TEST.out.theirs against TEST.out" 
fi 


# Generate test file 
../gen_registered_domain.py < TEST.dat > registered_domain.py

python registered_domain.py < TEST.domain > TEST.out
diff -q TEST.refout TEST.out || echo "There was an error"


python registered_domain.py < small-test.domain > small-test.out
diff -q small-test.refout small-test.out || echo "There was an error"


echo "Tests are done."
